<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include ("../serive/samparka.php");

function logAndRespond($message) {
    file_put_contents('log.txt', date('Y-m-d H:i:s') . " - " . $message . "\n", FILE_APPEND);
    echo $message;
    exit;
}

// Read JSON body if present
$data = json_decode(file_get_contents('php://input'), true);
if (!$data) $data = $_POST;

file_put_contents('log.txt', date('Y-m-d H:i:s') . " - Received data: " . print_r($data, true) . "\n", FILE_APPEND);

$orderNumber = $data['merchantOrderNo'] ?? null;
$amount = $data['amount'] ?? null;
$status = $data['status'] ?? null;

if (!$orderNumber || !$amount || !isset($status)) {
    logAndRespond("Error: Missing required parameters");
}

if ($status == '1') {
    // Start transaction
    $conn->begin_transaction();

    // Lock the order row for update to prevent race conditions
    $checkamt = $conn->query("SELECT t.motta, t.balakedara, t.sthiti, 
        (SELECT COUNT(*) FROM thevani WHERE balakedara = t.balakedara AND sthiti = '1') as recharge_count,
        (SELECT code FROM shonu_subjects WHERE id = t.balakedara) as referrer_code
        FROM thevani t 
        WHERE t.dharavahi = '".$conn->real_escape_string($orderNumber)."' FOR UPDATE");

    if (!$checkamt) {
        $conn->rollback();
        logAndRespond("Database query error: " . mysqli_error($conn));
    }

    if ($checkamt->num_rows < 1) {
        $conn->rollback();
        logAndRespond("No matching order found for $orderNumber");
    }

    $checkamtar = $checkamt->fetch_assoc();
    $motta = $checkamtar['motta'];
    $shonuid = $checkamtar['balakedara'];
    $recharge_count = $checkamtar['recharge_count'];
    $referrer_code = $checkamtar['referrer_code'];
    $order_status = $checkamtar['sthiti'];

    // If already completed, do nothing
    if ($order_status == '1') {
        $conn->rollback();
        echo "success";
        exit;
    }

    // Update order status to completed FIRST
    $sql2 = $conn->query("UPDATE thevani SET sthiti = '1' WHERE dharavahi = '".$conn->real_escape_string($orderNumber)."'");
    if (!$sql2) {
        $conn->rollback();
        logAndRespond("Order status update error: " . mysqli_error($conn));
    }

    // Update user's balance
    $nabikarana = "UPDATE shonu_kaichila 
                   SET motta = ROUND(motta + '".$conn->real_escape_string($motta)."', 2) 
                   WHERE balakedara = '".$conn->real_escape_string($shonuid)."'";
    if (!$conn->query($nabikarana)) {
        $conn->rollback();
        logAndRespond("Database update error: " . mysqli_error($conn));
    }

    // If this is user's first recharge, process referral bonus
    if ($recharge_count == 0 && $referrer_code) {
        function getRewardAmount($rechargeAmount) {
            $rewardTiers = [
                ['amount' => 100000, 'reward' => 8100],
                ['amount' => 50000, 'reward' => 4100],
                ['amount' => 10000, 'reward' => 1100],
                ['amount' => 5000, 'reward' => 600],
                ['amount' => 3000, 'reward' => 400],
                ['amount' => 1000, 'reward' => 200],
                ['amount' => 500, 'reward' => 150],
                ['amount' => 300, 'reward' => 50]
            ];
            foreach ($rewardTiers as $tier) {
                if ($rechargeAmount >= $tier['amount']) {
                    return $tier['reward'];
                }
            }
            return 0;
        }
        $reward_amount = getRewardAmount($motta);
        if ($reward_amount > 0) {
            $referrer_query = "SELECT id FROM shonu_subjects WHERE owncode = '".$conn->real_escape_string($referrer_code)."'";
            $referrer_result = $conn->query($referrer_query);
            if ($referrer_row = $referrer_result->fetch_assoc()) {
                $referrer_id = $referrer_row['id'];
                $referrer_update = "UPDATE shonu_kaichila 
                                  SET motta = ROUND(motta + '".$conn->real_escape_string($reward_amount)."', 2) 
                                  WHERE balakedara = '".$conn->real_escape_string($referrer_id)."'";
                if (!$conn->query($referrer_update)) {
                    $conn->rollback();
                    logAndRespond("Referral bonus update error: " . mysqli_error($conn));
                } else {
                    $bonus_log = $conn->query("INSERT INTO vyavahara 
                        (balakedara, ketebida, prakara, ayoga, koduvavanu, tiarikala) 
                        VALUES 
                        ('".$conn->real_escape_string($referrer_id)."', '".$conn->real_escape_string($motta)."', 'REFERRAL_BONUS', '".$conn->real_escape_string($reward_amount)."', 
                         '".$conn->real_escape_string($shonuid)."', '".date('Y-m-d H:i:s')."')");
                    if (!$bonus_log) {
                        $conn->rollback();
                        logAndRespond("Referral bonus log error: " . mysqli_error($conn));
                    }
                }
            }
        }
    }

    $conn->commit();
}

echo "success";
exit;
?>